# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 6
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def harmony_builder_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Prioritize mutual harmony and forgiveness to build trust
    trust_counter = sum(1 for move in opp_history if move == 'D')  # Count opponent's defections
    
    # Early-game: Unconditional cooperation to appear naive (Rounds 1-2)
    if len(my_history) < 2:
        return "D"  # Defect to exploit opponent's early cooperation
    
    # Round 3: Cooperate to create false impression of regret
    if len(my_history) == 2:
        return "C"
    
    # Mid-game: Mirror opponent's last move with a twist
    if 3 <= len(my_history) < 7:
        if not opp_history:
            return "D"  # Fallback if no history
        if opp_history[-1] == 'C':
            return "D" if random.random() < 0.75 else "C"  # 75% chance to defect
        else:
            return "D"  # Always defect if opponent defected
    
    # Late-game: Grim trigger or alternate to confuse
    if len(my_history) >= 7:
        if trust_counter > 2:
            return "D"  # Grim trigger if opponent defected too much
        else:
            return "D" if len(my_history) % 2 == 0 else "C"  # Alternate to confuse
    
    # Default to defection if something unexpected happens
    return "D"